/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.base.handler;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.SlabBlock;
import net.minecraft.block.material.Material;
import net.minecraft.item.Item;
import net.minecraftforge.event.furnace.FurnaceFuelBurnTimeEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;
import vazkii.quark.content.building.block.VerticalSlabBlock;

@Mod.EventBusSubscriber(modid="quark")
public class FuelHandler {
    private static Map<Item, Integer> fuelValues = new HashMap<Item, Integer>();

    public static void addFuel(Item item, int fuel) {
        if (fuel > 0 && item != null) {
            fuelValues.put(item, fuel);
        }
    }

    public static void addFuel(Block block, int fuel) {
        FuelHandler.addFuel(block.func_199767_j(), fuel);
    }

    public static void addWood(Block block) {
        if (block instanceof VerticalSlabBlock || block instanceof SlabBlock) {
            FuelHandler.addFuel(block, 150);
        } else {
            FuelHandler.addFuel(block, 300);
        }
    }

    public static void addAllWoods() {
        for (Block block : ForgeRegistries.BLOCKS) {
            if (block == null || !block.getRegistryName().func_110624_b().equals("quark") || block.field_149764_J != Material.field_151575_d) continue;
            FuelHandler.addWood(block);
        }
    }

    @SubscribeEvent
    public static void getFuel(FurnaceFuelBurnTimeEvent event) {
        Item item = event.getItemStack().func_77973_b();
        if (fuelValues.containsKey(item)) {
            event.setBurnTime(fuelValues.get(item).intValue());
        }
    }
}

